#include "camera.h"

#include <GL/glut.h>


Camera camera_init(Vec4 eye, Vec4 up, Vec4 target)
{
    Camera c;


    vec4_copy( eye, c.O );
    vec4_copy( up , c.Y );
    vec4_normalize(c.Y);

    vec4_diff(target, eye, c.Z);
    vec4_normalize(c.Z);

    vec4_cross_product(c.Z, c.Y, c.X);
    vec4_normalize(c.X);

    return c;
}

void camera_place(Camera c)
{
    Vec4 eye, aim, up;
    camera_get_eye(c, eye);
    camera_get_up(c, up);
    camera_get_target(c, aim);

    gluLookAt(eye[0], eye[1], eye[2],
              aim[0], aim[1], aim[2],
              up[0],  up[1],  up[2]
              );
}

void camera_get_eye(Camera c, Vec4 eye)
{
    vec4_copy(c.O, eye);
}

void camera_get_up(Camera c, Vec4 up)
{
    vec4_copy(c.Y, up);
}

void camera_get_target(Camera c, Vec4 target)
{
    vec4_sum(c.O, c.Z, target);
}

// Translation left and right
Camera camera_walksideway(Camera c, float step)
{
    Vec4 dl;
    vec4_mult_scalar(step, c.X, dl);
    vec4_sum(c.O, dl, c.O);
    return c;
}

// Translation front and back
Camera camera_walk(Camera c, float step)
{
    Vec4 dl;
    vec4_mult_scalar(step, c.Z, dl);
    vec4_sum(c.O, dl, c.O);
    return c;
}

// Rotation Up and down
Camera camera_pitch(Camera c, float step)
{
    Vec4 dl;
    vec4_mult_scalar(step, c.Y, dl);
    vec4_sum(c.Z, dl, c.Z);
    vec4_normalize(c.Z);
    vec4_cross_product(c.X, c.Z, c.Y);
    vec4_normalize(c.Y);
    return c;
}

// Rotation left and right
Camera camera_yaw(Camera c, float step)
{
    Vec4 dl;
    vec4_mult_scalar(step, c.X, dl);
    vec4_sum(c.Z, dl, c.Z);
    vec4_normalize(c.Z);
    vec4_cross_product(c.Z, c.Y, c.X);
    vec4_normalize(c.X);
    return c;
}
