#ifndef CAMERA_HPP__
#define CAMERA_HPP__

#include "vector4.h"

typedef struct {
    Vec4 O, X, Y, Z;
} Camera;

// Compute the camera frame according to eye, up and target
Camera camera_init(Vec4 eye, Vec4 up, Vec4 target);


// call gluLookAt() with the correct parameters
void camera_place(Camera c);


void camera_get_eye   (Camera c, Vec4 res_eye   );
void camera_get_up    (Camera c, Vec4 res_up    );
void camera_get_target(Camera c, Vec4 res_target);


// Translation left and right
Camera camera_walksideway(Camera c, float step);
// Translation front and back
Camera camera_walk(Camera c, float step);


// Rotation Up and down
Camera camera_pitch(Camera c, float step);
// Rotation left and right
Camera camera_yaw(Camera c, float step);

#endif  // CAMERA_HPP__
