#include "material.h"

#include <math.h>
#include <GL/gl.h>

void materials_set_opengl_state(Materials m)
{
    m.shininess = fmaxf(fminf(m.shininess, 128.f), 0.f);
    glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT ,  m.ambient);
    glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE ,  m.diffuse);
    glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR,  m.specular);
    glMaterialf (GL_FRONT_AND_BACK, GL_SHININESS, m.shininess);
}
