#ifndef VECTOR4_HPP__
#define VECTOR4_HPP__

typedef float Vec4[4];

/* initialize v = (a, b, c, d) */
void vec4_set(Vec4 v, float a, float b, float c, float d);

/* component wise copy v = res */
void vec4_copy(Vec4 v, Vec4 res);

/* cross product between v1 and v2 */
void vec4_cross_product(Vec4 v1, Vec4 v2, Vec4 res) ;

/* normalize v (i.e its length equal one) */
void vec4_normalize (Vec4 v);

/* COmponent wise sum */
void vec4_sum(Vec4 v1, Vec4 v2, Vec4 res);

/* res = v1-v2 */
void vec4_diff(Vec4 v1, Vec4 v2, Vec4 res);

/* Component wise multiplication by a scalar f */
void vec4_mult_scalar(float f, Vec4 v, Vec4 res);

#endif // VECTOR4_HPP__
