#include "mesh.h"

#include "vector4.h"
#include "glassert.h"
#include <stdio.h>
#include <stdlib.h>

Mesh* mesh_init(char* filename)
{
    FILE* f = 0; // file declaration
    char c[3];   // 3 char table
    int dummy = 0;

    // open a read-only file
    f = fopen(filename, "r");
    // Check if its opened
    if(f == 0)
    {
        fprintf(stderr, "ERROR: can't open %s\n", filename);
        exit(-1);
    }

    // allocation for a Mesh structure
    Mesh* mesh = (Mesh*)malloc( sizeof(Mesh) );

    // read the first 3 char of the file
    fread(c, sizeof(char), 3, f);
    // Check the file is an OFF file
    if(c[0] != 'O' || c[1] != 'F' || c[2] != 'F')
    {
        fprintf(stderr, "ERROR: wrong file format\n");
        exit(-1);
    }

    // read the number of vertices
    fscanf(f, "%d", &(mesh->nb_vertices));
    printf("nb vertices mesh: %d\n", mesh->nb_vertices);fflush(stdout);
    // Number of faces
    fscanf(f, "%d", &(mesh->nb_faces   ));
    printf("nb vertices mesh: %d\n", mesh->nb_faces);fflush(stdout);
    // number of edges
    fscanf(f, "%d", &dummy              );

    // memory allocation vertex coordinates
    mesh->verts = (float*)malloc( sizeof(float) * 3 * mesh->nb_vertices);

    // read the vertices x,y,z coordinates
    int i;
    for( i = 0; i < (mesh->nb_vertices * 3); i++)
    {
        fscanf (f, "%f", mesh->verts+i);
    }

    // memory allocation of the face index
    mesh->index = 0;

    // read the face index
    //for(...)

    // Allocate and compute the mesh normals
    mesh->normals = 0;
    // -------------------------------------

    // close the file
    fclose(f);

    return mesh;
}

void mesh_delete(Mesh* mesh)
{
    free( mesh->normals );
    free( mesh->verts   );
    free( mesh->index   );
    free( mesh          );
}

void mesh_draw(Mesh* mesh)
{
    GL_CHECK_ERRORS();
}
