#ifndef MESH_H__
#define MESH_H__

#include "material.h"

typedef struct {
    Materials mat;

    int nb_faces;     // Total number of vertices
    int nb_vertices;  // Total number of faces

    int*   index;     // List of triangles [ t00 t01 t02 | t10 t11 t12 | etc.]
    float* verts;     // List of vertices coordinates [ v0x v0y v0z | v1x v1y v1z | etc. ]
    float* normals;   // List of normals coordinates [ n0x n0y n0z | n1x n1y n1z | etc. ]

    int minY;         // Minimal y coordinate
}Mesh;


Mesh* mesh_init(char* filename);
void mesh_delete(Mesh* mesh);

void mesh_draw(Mesh* mesh);


#endif // MESH_H__
