#include "bezier.h"

#include <stdio.h>
#include <stdlib.h>
#include <GL/glew.h>
#include <assert.h>

// -----------------------------------------------------------------------------

Bezier* bezier_init(int nb_point)
{
    assert(nb_point > 2);

    Bezier* b = (Bezier*)malloc(sizeof(Bezier));

    b->ctrl_points = (Vec4*)malloc(sizeof(Vec4)*nb_point);
    b->nb_ctrl_points = nb_point;

    b->nb_samples = 0;
    b->samples    = 0;

    return b;
}

// -----------------------------------------------------------------------------

void bezier_delete(Bezier* b)
{
    free(b->ctrl_points);
    free(b->samples);
    free(b);
}

// -----------------------------------------------------------------------------

void bezier_set_ctrl_point(Bezier* b, Vec4 pt, int n)
{
    vec4_copy(pt, b->ctrl_points[n]);
}

// -----------------------------------------------------------------------------

void bezier_update_samples(Bezier* b, int nb_sample)
{
    free(b->samples);
    b->nb_samples = nb_sample;
    b->samples = (Vec4*)malloc(sizeof(Vec4)*nb_sample);

    // TODO Fill the array b->samples with points on the bezier curve
	// use bezier_eval() with different values of u to achieve this
}

// -----------------------------------------------------------------------------

void bezier_eval(Bezier* b, float u, Vec4 res)
{
    // Evaluation of a single point on the bezier curve with the de casteljau 
    // algorithm
}

// -----------------------------------------------------------------------------

void bezier_deval(Bezier* b, float u, Vec4 res)
{
    // Evaluation of the velocity on the bezier curve with the de casteljau 
    // algorithm
}

// -----------------------------------------------------------------------------

void bezier_ddeval(Bezier* b, float u, Vec4 res)
{
    // Evaluation of the aceleration on the bezier curve with the de casteljau 
    // algorithm
}

// -----------------------------------------------------------------------------

void bezier_draw(Bezier* b)
{
    // ...
}

// -----------------------------------------------------------------------------

void bezier_draw_ctrl_points(Bezier* b)
{
    // ...
}

// -----------------------------------------------------------------------------
