#ifndef BEZIER_H__
#define BEZIER_H__

#include "vector4.h"

typedef struct {

    Vec4* samples;       // Points on the bezier curve 
    int nb_samples;

    Vec4* ctrl_points;   // control points of the bezier curve
    int nb_ctrl_points;

}Bezier;


Bezier* bezier_init(int nb_point);

void bezier_delete(Bezier* b);

// Set the position of the ith control point
void bezier_set_ctrl_point(Bezier* b, Vec4 pt, int i);

// tesselate the bezier curve and store the result in the array 'samples'
void bezier_update_samples(Bezier* b, int nb_sample);

// Give the point on the bezier curve for a parameter u between [0 1]
void bezier_eval(Bezier* b, float u, Vec4 res);

// Give the velocity vector on the bezier curve for a parameter u between [0 1]
void bezier_deval(Bezier* b, float u, Vec4 res_tangent);

// Give the acceleration vector on the bezier curve for a parameter u between [0 1]
void bezier_ddeval(Bezier* b, float u, Vec4 res_normal);

// Draw the bezier curve
void bezier_draw(Bezier* b);

// Draw the bezier curve control points
void bezier_draw_ctrl_points(Bezier* b);


#endif // BEZIER_H__
